/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file     USB_User_API.h
\brief    Header for USB_User_API.c
\author   Freescale Semiconductor
\author   Guadalajara Applications Laboratory RTAC Americas
\author   Jose Ruiz
\version  1.0
\date     17/Oct/2007
\warning  
* History:

  30/July/2007      Start of bridge coding
  15/October/2007   Modifications for new version of bridges
  17/October/2007   Macros added and funcion names changed

*/

#ifndef _USB_User_API_H
#define _USB_User_API_H

/* Includes */
#include "derivative.h"
#include "Usb_Bdt.h"
#include "Usb_Drv.h"
#include "Usb_Descriptor.h"
#include "typedef.h"
#include "FSLTypes_File.h"

/*Defines */

#define EP1_Set Bdtmap.ep1Bio
#define EP2_Set Bdtmap.ep2Bio
#define EP3_Set Bdtmap.ep3Bio
#define EP4_Set Bdtmap.ep4Bio

/* Use these definitions for the API functions EndPoint_IN and CheckEndPointOUT */
#define EP0   0
#define EP1   1
#define EP2   2
#define EP3   3
#define EP4   4
/***********************/

/* External Variables Declaration */
extern UINT8 gu8DataOUTready;       //quitar extern
extern UINT8 EP1_Buffer[UEP1_SIZE];
extern UINT8 EP2_Buffer[UEP2_SIZE];
extern UINT8 EP3_Buffer[UEP3_SIZE];
extern UINT8 EP4_Buffer[UEP4_SIZE];

extern UINT8 EP1_OUT_SIZE;
extern UINT8 EP2_OUT_SIZE;
extern UINT8 EP3_OUT_SIZE;
extern UINT8 EP4_OUT_SIZE;

/* Function Prototypes */
void Endpoint_Init(void);
UINT8 CheckEndPointOUT(UINT8); 
void EndPoint_OUT(UINT8);
void EndPoint_IN(UINT8,UINT8);
UINT8 CheckINbuffer(UINT8);

#endif /* _USB_User_API_H */
